"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppDataSource = void 0;
require("reflect-metadata");
const typeorm_1 = require("typeorm");
const dotenv = __importStar(require("dotenv"));
const user_entity_1 = require("../entities/user.entity");
const vendor_entity_1 = require("../entities/vendor.entity");
const customer_entity_1 = require("../entities/customer.entity");
const category_entity_1 = require("../entities/category.entity");
const product_entity_1 = require("../entities/product.entity");
const product_variation_entity_1 = require("../entities/product-variation.entity");
const order_entity_1 = require("../entities/order.entity");
const order_detail_entity_1 = require("../entities/order-detail.entity");
const payment_entity_1 = require("../entities/payment.entity");
const transaction_entity_1 = require("../entities/transaction.entity");
const business_setting_entity_1 = require("../entities/business-setting.entity");
const shipping_method_entity_1 = require("../entities/shipping-method.entity");
const coupon_entity_1 = require("../entities/coupon.entity");
const review_entity_1 = require("../entities/review.entity");
const support_ticket_entity_1 = require("../entities/support-ticket.entity");
const cart_entity_1 = require("../entities/cart.entity");
const address_entity_1 = require("../entities/address.entity");
dotenv.config();
exports.AppDataSource = new typeorm_1.DataSource({
    type: 'mysql',
    host: process.env.DB_HOST || 'localhost',
    port: Number(process.env.DB_PORT) || 3306,
    username: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'ecommerce_db',
    entities: [
        user_entity_1.User,
        vendor_entity_1.Vendor,
        customer_entity_1.Customer,
        category_entity_1.Category,
        product_entity_1.Product,
        product_variation_entity_1.ProductVariation,
        order_entity_1.Order,
        order_detail_entity_1.OrderDetail,
        payment_entity_1.Payment,
        transaction_entity_1.Transaction,
        business_setting_entity_1.BusinessSetting,
        shipping_method_entity_1.ShippingMethod,
        coupon_entity_1.Coupon,
        review_entity_1.Review,
        support_ticket_entity_1.SupportTicket,
        cart_entity_1.Cart,
        address_entity_1.Address,
    ],
    migrations: ['src/migrations/*.ts'],
    synchronize: true,
    logging: true,
});
//# sourceMappingURL=data-source.js.map